//====================================================
// Normal Mapping
//====================================================
// By EVOLVED
// www.evolved-software.com
//====================================================

//--------------
// un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   
   matrix ViewInv:ViewInverse; 
//--------------
// Textures
//--------------
   texture BaseTexture <string Name="";>;	
   sampler BaseSampler=sampler_state 
      {
 	texture=<BaseTexture>;
      };

//--------------
// structs 
//--------------

   struct In_Geometry
     {
 	float4 Pos:POSITION;
 	float2 Tex:TEXCOORD0;
 	float2 Tex1:TEXCOORD2;	
 	float2 Tex2:TEXCOORD3;
 	float4 Color:COLOR; 	

     };
   struct Out_Geometry
     {
	float4 Pos:POSITION; 
   	float4 Tex:TEXCOORD1;
 	//float2 Tex1:TEXCOORD6;  
 	float3 Color:COLOR;   	 	   
     };
      

//--------------
// vertex shader
//--------------
   Out_Geometry VS_Geometry(In_Geometry IN) 
     {
  	Out_Geometry OUT;	

	OUT.Pos=mul(IN.Pos,WorldVP); 	
		  	 		
 	OUT.Tex=float4(IN.Tex,IN.Tex2);
   // OUT.Tex1=float2(IN.Tex1.x,IN.Tex1.y);
 	//OUT.Color=float3(IN.Tex1,IN.Tex2.x);
 	OUT.Color=IN.Color.w;	
	
	
	return OUT;
     }


//--------------
// pixel shader
//--------------
      
   float4 PS_AO(Out_Geometry IN) : COLOR
     {

float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);	

//clip(Diffuse.w-0.25);
//Diffuse.xyz*=saturate(pow(IN.Color,1.0)*1.0);//+0.5; //float3(IN.Tex1.xy,IN.Tex2.x);

Diffuse.xyz*=IN.Color;
Diffuse.xyz=IN.Color;
//Diffuse.xyz=IN.Tex1.xyx;//
	return float4(Diffuse.xyz,1);	
     }
     
   float4 PS_TextureAO(Out_Geometry IN) : COLOR
     {

float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);	

//clip(Diffuse.w-0.25);
//Diffuse.xyz*=saturate(pow(IN.Color,1.0)*1.0);//+0.5; //float3(IN.Tex1.xy,IN.Tex2.x);

Diffuse.xyz*=saturate(IN.Color+0.1);



clip( tex2Dlod(BaseSampler,float4(IN.Tex.xy,0,0)).w-0.05);
//Diffuse.xyz=IN.Color;
//Diffuse.xyz=IN.Tex1.xyx;//
	return float4(Diffuse.xyz,1);	
     }
          
        
 
//--------------
// techniques   
//--------------

   technique AO
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS_Geometry(); 
 	pixelShader  = compile ps_3_0 PS_AO(); 
	//colorwriteenable=7;
   // SrcBlend=srcalpha;	
	//zwriteenable=false;
	
      }
      }
      
   technique TextureAO
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS_Geometry(); 
 	pixelShader  = compile ps_3_0 PS_TextureAO(); 
	//colorwriteenable=7;
   // SrcBlend=srcalpha;	
	//zwriteenable=false;
	
      }
      }
           