/*********************************************************************NVMH3****
Path:  NVSDK\Common\media\cgfx
File:  $Id: //sw/devrel6/SDK/MEDIA/CgFX/velvety.fx#1 $

Copyright NVIDIA Corporation 2002
TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, THIS SOFTWARE IS PROVIDED
*AS IS* AND NVIDIA AND ITS SUPPLIERS DISCLAIM ALL WARRANTIES, EITHER EXPRESS
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL NVIDIA OR ITS SUPPLIERS
BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT, OR CONSEQUENTIAL DAMAGES
WHATSOEVER (INCLUDING, WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR ANY OTHER PECUNIARY LOSS)
ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF NVIDIA HAS
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.


Comments:
    A dead-simple combination of vertex and pixel shaders for dx8-class shading.
    Simple one-pass lambertian shading of a textured surface is the name
	of the game.

******************************************************************************/

string Category = "Effects\\Cg\\Lighting";
string keywords = "dx8,pointlight";
string description = "Soft diffuse surface with velvety contour rims";

/************* UN-TWEAKABLES **************/

float4x4 worldIT : WorldIT;
float4x4 wvp : WorldViewProjection;
float4x4 world : World;
float4x4 viewIT : ViewIT;

/************* TWEAKABLES **************/

float4 lightPos : Position
<
	string Object = "PointLight";
	string Space = "World";
> = {100.0f, 100.0f, 100.0f, 0.0f};

float4 ambiColor : Ambient = {0.1f, 0.1f, 0.1f, 1.0f};
float4 diffColor : Diffuse = {0.5f, 0.5f, 0.5f, 1.0f};
float4 specColor : Specular = {0.7f, 0.7f, 0.75f, 1.0f};
float4 subColor : Diffuse = {0.2f, 0.2f, 1.0f, 1.0f};

float rollOff 
<
    string gui = "slider";
    float uimin = 0.0;
    float uimax = 1.0;
    float uistep = 0.05;
> = 0.3;

float normalSign
<
    string gui = "slider";
    float uimin = -1.0;
    float uimax = 1.0;
    float uistep = 2.0;
> = 1.0;

/************* DATA STRUCTS **************/

/* data from application vertex buffer */
struct appdata {
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
};

/* data passed from vertex shader to pixel shader */
struct vertexOutput {
    float4 HPosition	: POSITION;
    float4 TexCoord0	: TEXCOORD0;
    float4 diffCol	: COLOR0;
};

/* Output pixel values */
struct pixelOutput {
  float4 col : COLOR;
};

/*********** vertex shader ******/

vertexOutput labVS(appdata IN,
    uniform float4x4 WorldViewProj,
    uniform float4x4 WorldIT,
    uniform float4x4 World,
    uniform float4x4 ViewIT,
    uniform float4 AmbiColor,
    uniform float4 DiffColor,
    uniform float4 SpecColor,
    uniform float3 LightPos,
    uniform float4 SubColor,
    uniform float RollOff,	// sine of rolloff angle
    uniform float NormalSign
) {
    vertexOutput OUT;
    float3 Nn = mul(WorldIT, IN.Normal).xyz;
    Nn = normalize(Nn);
    Nn.x = NormalSign * Nn.x;	// uggggggly! but the viewer crashed otherwise
    Nn.y = NormalSign * Nn.y;	// uggggggly!
    Nn.z = NormalSign * Nn.z;	// uggggggly!

    float4 Po = float4(IN.Position.xyz, 1.0);
    float3 Pw = mul(World, Po).xyz;
    float3 Ln = normalize(LightPos - Pw);
    float ldn = dot(Ln,Nn);
    float diffComp = max(0,ldn);
    float4 diffContrib = diffComp * DiffColor;
    diffContrib.w = 1.0;

    float subLamb = smoothstep(-RollOff,1.0,ldn) - smoothstep(0.0,1.0,ldn);
    subLamb = max(0.0,subLamb);
    float4 subContrib = subLamb * SubColor;

    OUT.TexCoord0 = IN.UV;

    float3 Vn = normalize(ViewIT[3].xyz - Pw);
    float vdn = 1.0 - dot(Vn,Nn);
    float4 vecColor = float4(vdn.xxx, 1.0);
    OUT.diffCol = subContrib+diffContrib+(vecColor*SpecColor);
    OUT.HPosition = mul(WorldViewProj, Po);
    return OUT;
}

/********* pixel shader ********/

pixelOutput labPS(vertexOutput IN
) {
    pixelOutput OUT; 
    float4 result = IN.diffCol;
    OUT.col = result;
    return OUT;
}

/*************/

technique ps11
{
	pass p0 
	{		
		VertexShader = compile vs_1_1 labVS(wvp,worldIT,
					world,viewIT,
					ambiColor,diffColor,specColor,
					lightPos,subColor,rollOff,normalSign);
		ZEnable = true;
		ZWriteEnable = true;
		CullMode = None;
		PixelShader = compile ps_1_1 labPS();
	}
}

/***************************** eof ***/
