
 matrix WorldVP:WorldViewProjection; 

 float blurWidth <> = 0.02f;
 float Brightness <> = 0.18f;

 texture screen 
    <
    	string Name = " ";
    >;
 sampler2D screen_sample=sampler_state 
    {
	Texture=<screen>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
    };

 struct input
     {
 	float4 pos : POSITION ; 
 	float2 UV  : TEXCOORD ; 
     };
 struct output
     {
	float4 out_pos  : POSITION;
  	float2 uva 	: TEXCOORD0;
  	float2 uvb 	: TEXCOORD1;
  	float2 uvc 	: TEXCOORD2;
  	float2 uvd 	: TEXCOORD3;
      };

 output VS_blurA(input IN)
      {
   	output OUT;
    	OUT.uva = IN.UV+blurWidth*(1*float2(1.5,0.5));
    	OUT.uvb = IN.UV+blurWidth*(1*float2(0.5,0.5)); 
    	OUT.uvc = IN.UV+blurWidth*(1*float2(-0.5,0.5));
    	OUT.uvd = IN.UV+blurWidth*(1*float2(-1.5,0.5));
    	OUT.out_pos  = mul(IN.pos,WorldVP);
   	return OUT;
      }
 output VS_blurB(input IN)
      {
   	output OUT;
    	OUT.uva = IN.UV+blurWidth*(1*float2(1.5,1.5));
    	OUT.uvb = IN.UV+blurWidth*(1*float2(0.5,1.5)); 
    	OUT.uvc = IN.UV+blurWidth*(1*float2(-0.5,1.5));
    	OUT.uvd = IN.UV+blurWidth*(1*float2(-1.5,1.5));
    	OUT.out_pos  = mul(IN.pos,WorldVP);
   	return OUT;
      }
 output VS_blurC(input IN)
      {
   	output OUT;
    	OUT.uva = IN.UV+blurWidth*(1*float2(1.5,-0.5));
    	OUT.uvb = IN.UV+blurWidth*(1*float2(0.5,-0.5)); 
    	OUT.uvc = IN.UV+blurWidth*(1*float2(-0.5,-0.5));
    	OUT.uvd = IN.UV+blurWidth*(1*float2(-1.5,-0.5));
    	OUT.out_pos  = mul(IN.pos,WorldVP);
   	return OUT;
      }
 output VS_blurD(input IN)
      {
   	output OUT;
    	OUT.uva = IN.UV+blurWidth*(1*float2(1.5,-1.5));
    	OUT.uvb = IN.UV+blurWidth*(1*float2(0.5,-1.5)); 
    	OUT.uvc = IN.UV+blurWidth*(1*float2(-0.5,-1.5));
    	OUT.uvd = IN.UV+blurWidth*(1*float2(-1.5,-1.5));
    	OUT.out_pos  = mul(IN.pos,WorldVP);
   	return OUT;
      }

 float4 PS_blurA(output IN) : COLOR
      {
   	float4 tex=tex2D(screen_sample, IN.uva)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvb);
   	tex=tex+tex2D(screen_sample,IN.uvc);
   	tex=tex+tex2D(screen_sample,IN.uvd)/2.5;	
  	return (tex*Brightness);
      } 
 float4 PS_blurB(output IN) : COLOR
      {
   	float4 tex=tex2D(screen_sample, IN.uva)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvb)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvc)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvd)/2.5;	
  	return (tex*Brightness);
      } 
 float4 PS_blurC(output IN) : COLOR
      {
   	float4 tex=tex2D(screen_sample, IN.uva)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvb);
   	tex=tex+tex2D(screen_sample,IN.uvc);
   	tex=tex+tex2D(screen_sample,IN.uvd)/2.5;	
  	return (tex*Brightness);
      } 
 float4 PS_blurD(output IN) : COLOR
      {
   	float4 tex=tex2D(screen_sample, IN.uva)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvb)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvc)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvd)/2.5;
  	return (tex*Brightness);
      } 

 technique blurpass
      {
	pass p1
      {
   	VertexShader = compile vs_1_1 VS_blurA();
   	PixelShader  = compile ps_1_1 PS_blurA();
    	SrcBlend = One;
    	DestBlend = One;
      }
  	pass p2
      {
   	VertexShader = compile vs_1_1 VS_blurB();
   	PixelShader  = compile ps_1_1 PS_blurB();
    	SrcBlend = One;
    	DestBlend = One;
 	AlphaBlendEnable = True;
      }
  	pass p3
      {
   	VertexShader = compile vs_1_1 VS_blurC();
   	PixelShader  = compile ps_1_1 PS_blurC();
    	SrcBlend = One;
    	DestBlend = One;
 	AlphaBlendEnable = True;
      }
	pass p4
      {
    	VertexShader = compile vs_1_1 VS_blurD();
    	PixelShader  = compile ps_1_1 PS_blurD();
    	SrcBlend = One;
    	DestBlend = One;
 	AlphaBlendEnable = True;
      }
      }




	
