//
// Green Gandalf's Scrolling Lava v1.0 
// Created 25 August 2006
//
// Scrolls and distorts a simple lava image.

matrix wvp : WorldViewProjection;
matrix mworld : World;
float timer : Time;

texture colorTexture < string ResourceName = "lava_D.dds"; >;
sampler2D   sampler0 = sampler_state 
{  texture = <colorTexture>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
    AddressU = Wrap;
    AddressV = Wrap;
    AddressW = Wrap;
  };

float freq1 = 3.0;
float freq2 = 3.5;
float timeScale = 40.0;
float warpScale = 0.35;

struct VS_INPUT
{   float4 Pos          : POSITION;
    float2 Tex          : TEXCOORD0;
};

struct VS_OUTPUT
{   float4 Pos          : POSITION;
    float2 Tex          : TEXCOORD0;
    float time          : TEXCOORD1;
    float2 warp         : TEXCOORD2;
};

VS_OUTPUT GGLavaVShader(VS_INPUT In, VS_OUTPUT Out)
{   Out.Pos = mul(In.Pos, wvp);
    float timeNow = (timer/timeScale);
    Out.Tex = In.Tex+float2 (timeNow,0.0);
    Out.time = timeNow;
    Out.warp = float2 (sin(freq1*timeNow),cos(freq2*timeNow));
    return Out;
}

struct PS_INPUT
{   float2 Tex       : TEXCOORD0;
    float time     : TEXCOORD1;
    float2 warp    : TEXCOORD2;
};
struct PS_OUTPUT
{  float4 col : COLOR;
};

PS_OUTPUT GGLavaPShader(PS_INPUT In, PS_OUTPUT Out)
{  float2 temp = In.Tex;
   float4 baseColour = tex2D( sampler0, temp);
   temp = temp + In.warp*baseColour.xy*warpScale;
   baseColour = tex2D( sampler0, temp);
   Out.col = baseColour ;
   return Out;
}

technique t0
{   pass p0
    {  VertexShader = compile vs_2_0 GGLavaVShader();
       PixelShader = compile ps_2_0 GGLavaPShader();
    }
}
