//
// FX Effect file - WEIRD QUAD
//

texture background < string Name=""; >;	
float ticks : Time;
float timeScale=0.005;

sampler2D background_smp = sampler_state 
{
	Texture = <background>;
	AddressU = Clamp; AddressV = Clamp;
	MinFilter = Linear; MagFilter = Linear; MipFilter = None;
};

struct output
{
	float4 opos    : POSITION;  
 	float2 uv      : TEXCOORD0;  
};

output VS( float4 pos : POSITION )
{
	output OUT;
	float timeNow = ((ticks/100.0)/timeScale);
	float wiggle = sin(timeNow) * 0.1;
	OUT.uv = pos.xy * float2(0.5+wiggle,-0.5+wiggle) + 0.5;
	OUT.uv += float2(wiggle,wiggle);
	OUT.opos = pos;
	return OUT;	
}

float4 PS(output IN) : COLOR
{
	return tex2D(background_smp,IN.uv);
}
  
technique screenquad
{
	pass p0
	{		
		VertexShader = compile vs_1_0 VS();
		PixelShader  = compile ps_1_0 PS();	
	}
}

