//
// Tone input to produce screen space output
//

texture screen < string Name=""; >;	

sampler2D screen_sample=sampler_state 
{
	Texture=<screen>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
};

struct input
{
 	float4 pos : POSITION ; 
 	float2 UV  : TEXCOORD ; 
};

struct output
{
 	float4 opos     : POSITION;  
  	float2 uva 	: TEXCOORD0;
};

output VS_tone(input IN)
{
   	output OUT;
    	OUT.uva = IN.UV;
    	OUT.opos=IN.pos;
   	return OUT;
}

float4 PS_tone(output IN)  : COLOR
{
 	float4 color=tex2D(screen_sample,IN.uva);
 	color.xyz=pow(color.xyz,10.0);
	return color;
}

technique tonetechnique
{
	pass p1
	{
  		vertexShader = compile vs_1_1 VS_tone(); 
		pixelShader  = compile ps_2_0 PS_tone(); 	
	}
}
