//
// Redner direct to screen space
//

texture screen < string Name=""; >;	
texture bloom < string Name=""; >;	

sampler2D screen_sample=sampler_state 
{
	Texture=<screen>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
};

sampler2D bloom_sample=sampler_state 
{
	Texture=<bloom>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
};

struct input
{
 	float4 pos : POSITION ; 
 	float2 UV  : TEXCOORD ; 
};

struct output
{
 	float4 opos    : POSITION  ;  
 	float2 uv      : TEXCOORD0 ;  
};

output vs(input IN) 
{
 	output OUT;
 	OUT.opos=IN.pos;
 	OUT.uv=IN.UV; 
 	return OUT;
}

float4 ps_bo(output IN)  : COLOR
{
 	float4 color=tex2D(screen_sample,IN.uv);
 	float4 bright=tex2D(bloom_sample,IN.uv);
	float4 result = color + bright;	
	return result;	
}

technique bloomonly
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_0 ps_bo(); 	
	}
}

