//
// Blur input to produce screen space output
//

float blurWidth <> = 0.025f;
float Brightness <> = 0.5f;

texture screen < string Name=""; >;	

sampler2D screen_sample=sampler_state 
{
	Texture=<screen>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
};

struct input
{
 	float4 pos : POSITION ; 
 	float2 UV  : TEXCOORD ; 
};

struct output
{
 	float4 opos     : POSITION;  
  	float2 uva 	: TEXCOORD0;
  	float2 uvb 	: TEXCOORD1;
  	float2 uvc 	: TEXCOORD2;
  	float2 uvd 	: TEXCOORD3;
};

output VS_blurA(input IN)
{
   	output OUT;
    	OUT.uva = IN.UV+blurWidth*(1*float2(1.5,0.5));
    	OUT.uvb = IN.UV+blurWidth*(1*float2(0.5,0.5)); 
    	OUT.uvc = IN.UV+blurWidth*(1*float2(-0.5,0.5));
    	OUT.uvd = IN.UV+blurWidth*(1*float2(-1.5,0.5));
    	OUT.opos=IN.pos;
   	return OUT;
}

output VS_blurB(input IN)
{
   	output OUT;
    	OUT.uva = IN.UV+blurWidth*(1*float2(1.5,1.5));
    	OUT.uvb = IN.UV+blurWidth*(1*float2(0.5,1.5)); 
    	OUT.uvc = IN.UV+blurWidth*(1*float2(-0.5,1.5));
    	OUT.uvd = IN.UV+blurWidth*(1*float2(-1.5,1.5));
    	OUT.opos=IN.pos;
   	return OUT;
}

output VS_blurC(input IN)
{
   	output OUT;
    	OUT.uva = IN.UV+blurWidth*(1*float2(1.5,-0.5));
    	OUT.uvb = IN.UV+blurWidth*(1*float2(0.5,-0.5)); 
    	OUT.uvc = IN.UV+blurWidth*(1*float2(-0.5,-0.5));
    	OUT.uvd = IN.UV+blurWidth*(1*float2(-1.5,-0.5));
    	OUT.opos=IN.pos;
   	return OUT;
}

output VS_blurD(input IN)
{
   	output OUT;
    	OUT.uva = IN.UV+blurWidth*(1*float2(1.5,-1.5));
    	OUT.uvb = IN.UV+blurWidth*(1*float2(0.5,-1.5)); 
    	OUT.uvc = IN.UV+blurWidth*(1*float2(-0.5,-1.5));
    	OUT.uvd = IN.UV+blurWidth*(1*float2(-1.5,-1.5));
    	OUT.opos=IN.pos;
   	return OUT;
}

float4 PS_blurA(output IN) : COLOR
{
   	float4 tex=tex2D(screen_sample, IN.uva)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvb)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvc)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvd)/2.5;	
  	return (tex*Brightness);
} 

float4 PS_blurB(output IN) : COLOR
{
   	float4 tex=tex2D(screen_sample, IN.uva)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvb)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvc)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvd)/2.5;	
  	return (tex*Brightness);
} 

float4 PS_blurC(output IN) : COLOR
{
   	float4 tex=tex2D(screen_sample, IN.uva)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvb);
   	tex=tex+tex2D(screen_sample,IN.uvc);
   	tex=tex+tex2D(screen_sample,IN.uvd)/2.5;	
  	return (tex*Brightness);
} 

float4 PS_blurD(output IN) : COLOR
{
   	float4 tex=tex2D(screen_sample, IN.uva)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvb)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvc)/2.5;
   	tex=tex+tex2D(screen_sample,IN.uvd)/2.5;
  	return (tex*Brightness);
} 

technique blurtechnique
{
	pass p1
	{
  		vertexShader = compile vs_1_1 VS_blurA(); 
		pixelShader  = compile ps_3_0 PS_blurA(); 
	    	SrcBlend = One;
    		DestBlend = One;
	}
	pass p2
	{
  		vertexShader = compile vs_1_1 VS_blurB(); 
		pixelShader  = compile ps_3_0 PS_blurB(); 
	    	SrcBlend = One;
    		DestBlend = One;
	 	AlphaBlendEnable = True;
	}
	pass p3
	{
  		vertexShader = compile vs_1_1 VS_blurC(); 
		pixelShader  = compile ps_3_0 PS_blurC(); 
	    	SrcBlend = One;
    		DestBlend = One;
	 	AlphaBlendEnable = True;
	}
	pass p4
	{
  		vertexShader = compile vs_1_1 VS_blurD(); 
		pixelShader  = compile ps_3_0 PS_blurD(); 
	    	SrcBlend = One;
    		DestBlend = One;
	 	AlphaBlendEnable = True;
	}
}
