string description = "Post Process Distort";

float tile
<
	string UIName = "Tile Factor";
	string UIWidget = "slider";
	float UIMin = 1.0;
	float UIStep = 1.0;
	float UIMax = 32.0;
> = 2;

float depth
<
	string UIName = "Depth Factor";
	string UIWidget = "slider";
	float UIMin = 0.0f;
	float UIStep = 0.01f;
	float UIMax = 0.25f;
> = 0.05;

float3 ambient
<
	string UIName = "Ambient";
	string UIWidget = "color";
> = {0.3,0.3,0.3};

float3 diffuse
<
	string UIName = "Diffuse";
	string UIWidget = "color";
> = {1,1,1};

float3 specular
<
	string UIName = "Specular";
	string UIWidget = "color";
> = {0.4,0.4,0.4};

float shine
<
    string UIName = "Shine";
	string UIWidget = "slider";
	float UIMin = 8.0f;
	float UIStep = 8;
	float UIMax = 256.0f;
> = 128.0;


float3 lightpos : POINTLIGHT
<
	string UIName="Light Position";
> = { 0.0, 40.0, 820.0 };

float4x4 modelviewproj : WorldViewProjection;
float4x4 modelview : WorldView;
float4x4 modelinv : WorldInverse;
float4x4 view : View;

texture scenemap : DIFFUSE
<
    string Name = "fromscene.tga";
    string Type = "2D";
>;

texture normalmap : NORMAL
<
    string Name = "heathazenormal.tga";
    string Type = "2D";
>;

sampler2D scenemap_sampler = sampler_state
{
	Texture = <scenemap>;
	MinFilter = Anisotropic;
	MagFilter = Anisotropic;
	MipFilter = Anisotropic;
};

sampler2D normalmap_sampler = sampler_state
{
	Texture = <normalmap>;
	MinFilter = Anisotropic;
	MagFilter = Anisotropic;
	MipFilter = Anisotropic;
};

struct a2v 
{
    float4 pos		: POSITION;
    float4 color	: COLOR0;
    float3 normal	: NORMAL;
    float2 txcoord	: TEXCOORD0;
};

struct v2f
{
    float4 hpos		: POSITION;
    float2 txcoord	: TEXCOORD0;
    float3 vpos		: TEXCOORD1;
    float3 normal	: TEXCOORD2;
    float4 Proj		: TEXCOORD3;
    float Depth		: TEXCOORD4;
};

v2f view_space(a2v IN)
{
	v2f OUT;

	// vertex position in object space
	float4 pos=float4(IN.pos.x,IN.pos.y,IN.pos.z,1.0);

	// compute modelview rotation only part
	float3x3 modelviewrot;
	modelviewrot[0]=modelview[0].xyz;
	modelviewrot[1]=modelview[1].xyz;
	modelviewrot[2]=modelview[2].xyz;

	// vertex position in clip space
	OUT.hpos=mul(pos,modelviewproj);

	// vertex position in view space (with model transformations)
	OUT.vpos=mul(pos,modelview).xyz;

	// tangent space vectors in view space (with model transformations)
	OUT.normal=mul(IN.normal,modelviewrot);
	
	// copy texture coordinates
	OUT.txcoord=IN.txcoord.xy;

	float4x4 scalemat = float4x4(0.5,0,0,0.5,0,-0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);
  	OUT.Proj = mul(scalemat,OUT.hpos);

	OUT.Depth = (abs(pos.z-(modelview[3].z+20)) / 250.0);

	return OUT;
}

float4 parallax_map(
	v2f IN,
	uniform sampler2D scenemap,
	uniform sampler2D normalmap) : COLOR
{
   	// view directions
	float3 v = normalize(IN.vpos);

	// displace UV 
	float2 uv = IN.txcoord;

	// color map
	float4 Distort = (tex2D(normalmap, uv)*2-1);
  	Distort = Distort * (IN.Proj.z*0.001);
	float4 color=tex2Dproj(scenemap,IN.Proj+Distort);

        // alpha controls depth of field
        color.w=IN.Depth;

	return color;
}

technique parallax_mapping
{
    pass p0 
    {
    	CullMode = CCW;
		VertexShader = compile vs_1_1 view_space();
		PixelShader  = compile ps_2_0 parallax_map(scenemap_sampler,normalmap_sampler);
    }
}
