
matrix WorldVP:WorldViewProjection; 

int NumSamples=12;
float2 TwelveKernelBase[12] =
{
    { 1.0f,  0.0f},
    { 0.5f,  0.8660f},
    {-0.5f,  0.8660f},
    {-1.0f,  0.0f},
    {-0.5f, -0.8660f},
    { 0.5f, -0.8660f},
    { 1.5f,  0.8660f},
    { 0.0f,  1.7320f},
    {-1.5f,  0.8660f},
    {-1.5f, -0.8660f},
    { 0.0f, -1.7320f},
    { 1.5f, -0.8660f},
};


texture screen < string Name=""; >;	

sampler2D screen_sample=sampler_state 
{
	Texture=<screen>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
};

struct input
{
 	float4 pos : POSITION ; 
 	float2 UV  : TEXCOORD ; 
};

struct output
{
 	float4 opos    : POSITION  ;  
 	float2 uv      : TEXCOORD0 ;  
};

output vs(input IN) 
{
 	output OUT;
 	OUT.opos=mul(IN.pos,WorldVP);
 	OUT.uv=IN.UV; 
 	return OUT;
}

float4 ps(output IN)  : COLOR
{
	float4 Original=tex2D(screen_sample,IN.uv);
	float3 Blurred = 0;
        float blurfactor=0.5;
	for(int i = 0; i < NumSamples; i++)
	{
  	  float4 Current = tex2D(screen_sample, IN.uv + (TwelveKernelBase[i]/500.0));   
	  Blurred += lerp(Original.rgb, Current.rgb, saturate(Original.a*Current.a)*blurfactor);
	}
	return float4(Blurred / NumSamples, 1.0f);
}
  
technique qtone
{
      pass p1
      {		
  	vertexShader = compile vs_1_1 vs(); 
  	pixelShader  = compile ps_2_b ps(); 	
      }
}
