//********************************************************************************************
//
// refraction     
//   	   
//	
/////////////////////////////////////////////
// un-TWEAKABLES 
	matrix WorldViewProj : WorldViewProjection;
//********************************************************************************************
// Textures
   texture colorTexture < string Name = "wood.jpg"; >;	
	sampler2D colorSampler = sampler_state
		{
		Texture = <colorTexture>;
   	   		ADDRESSU = CLAMP;
   			ADDRESSV = CLAMP;
   			ADDRESSW = CLAMP;
   			MIPFILTER = NONE;
   			MINFILTER = LINEAR;
   			MAGFILTER = LINEAR;
		};
   texture normalTexture <string Name = "bump1.jpg"; >; 
	sampler2D normalSampler = sampler_state 
		{
		Texture = <normalTexture>;
		};
//********************************************************************************************
// DATA STRUCTS 
	struct VS_OUTPUT 
	{
		float4 Pos: POSITION;
		float2 uv: TEXCOORD0;
		float3 view: TEXCOORD1;

	};
//********************************************************************************************
	VS_OUTPUT mainVS(float4 Pos: POSITION, float2 texcoord0 : TEXCOORD0)
	{
		VS_OUTPUT Out;
			float4 pos = float4(1 * Pos.x, 1 * Pos.y, 1 * Pos.z, 1);
			float4 pPos = mul(float4(pos.xyz,1), WorldViewProj);
				Out.Pos = pPos;
				Out.uv = texcoord0.xy;
			Out.view.x = 0.5 * (pPos.z + pPos.x);
			Out.view.y = 0.5 * (pPos.z - pPos.y);
			Out.view.z = pPos.z * 1;
		return Out;
	}
//********************************************************************************************
	float4 PS_refractbump(float2 uv:TEXCOORD0,float3 view:TEXCOORD1) : COLOR 
	{
			float4 NB = tex2D(normalSampler,uv)*2-1;
			NB = normalize(NB);
			NB=NB*0.01;
			float2 nuv=float2(view.x,view.y)/view.z+NB ;
   			float4 refraction = tex2D(colorSampler,nuv);
   			//refraction.r-=0.1;
   			//refraction.g-=0.1;
   			//refraction.b-=0.05;
	
		return refraction;
	}

//
// techniques
//

technique on
{
	pass p1
	{		
		VertexShader = compile vs_1_1 mainVS(); 
		PixelShader = compile ps_2_0 PS_refractbump(); 		
	}
}


