//
// Render direct to screen space
//

int NumSamples=12;
float2 TwelveKernelBase[12] =
{
    { 1.0f,  0.0f},
    { 0.5f,  0.8660f},
    {-0.5f,  0.8660f},
    {-1.0f,  0.0f},
    {-0.5f, -0.8660f},
    { 0.5f, -0.8660f},
    { 1.5f,  0.8660f},
    { 0.0f,  1.7320f},
    {-1.5f,  0.8660f},
    {-1.5f, -0.8660f},
    { 0.0f, -1.7320f},
    { 1.5f, -0.8660f},
};

float BlurFactor
<
    string UIName =  "Strength Of Depth of Field Blur";
> = 1.0f;

texture screen < string Name=""; >;	
texture shadow < string Name=""; >;	
texture bloom < string Name=""; >;	

sampler2D screen_sample=sampler_state 
{
	Texture=<screen>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
};

sampler2D shadow_sample=sampler_state 
{
	Texture=<shadow>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
};

sampler2D bloom_sample=sampler_state 
{
	Texture=<bloom>;
   	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
};

struct input
{
 	float4 pos : POSITION ; 
 	float2 UV  : TEXCOORD ; 
};

struct output
{
 	float4 opos    : POSITION  ;  
 	float2 uv      : TEXCOORD0 ;  
};

output vs(input IN) 
{
 	output OUT;
 	OUT.opos=IN.pos;
 	OUT.uv=IN.UV; 
 	return OUT;
}

float4 ps_all(output IN)  : COLOR
{
	float4 Original=tex2D(screen_sample,IN.uv);
	float3 Blurred = 0;
	for(int i = 0; i < NumSamples; i++)
	{
  	  float4 Current = tex2D(screen_sample, IN.uv + (TwelveKernelBase[i]/500.0));   
	  float origa = 1 - Original.a;
	  float curra = 1 - Current.a;
	  Blurred += lerp(Original.rgb, Current.rgb, saturate(origa*curra)*BlurFactor);
	}
 	float4 color=float4(Blurred / NumSamples, 1.0f);
 	float4 shade=tex2D(shadow_sample,IN.uv);
	float4 bright=tex2D(bloom_sample,IN.uv);
	float4 result = (color * shade) + bright;	
	return result;	
}

float4 ps(output IN)  : COLOR
{
 	float4 color=tex2D(screen_sample,IN.uv);
 	float4 shade=tex2D(shadow_sample,IN.uv);
 	float4 bright=tex2D(bloom_sample,IN.uv);
	float4 result = (color * shade) + bright;	
	return result;	
}

float4 ps_so_dof(output IN)  : COLOR
{
	float4 Original=tex2D(screen_sample,IN.uv);
	float3 Blurred = 0;
	for(int i = 0; i < NumSamples; i++)
	{
  	  float4 Current = tex2D(screen_sample, IN.uv + (TwelveKernelBase[i]/500.0));   
	  float origa = 1 - Original.a;
	  float curra = 1 - Current.a;
	  Blurred += lerp(Original.rgb, Current.rgb, saturate(origa*curra)*BlurFactor);
	}
 	float4 color=float4(Blurred / NumSamples, 1.0f);
 	float4 shade=tex2D(shadow_sample,IN.uv);
	float4 result = color * shade;	
	return result;	
}

float4 ps_so(output IN)  : COLOR
{
 	float4 color=tex2D(screen_sample,IN.uv);
 	float4 shade=tex2D(shadow_sample,IN.uv);
 	float4 bright=tex2D(bloom_sample,IN.uv);
	float4 result = color * shade;	
	return result;	
}

float4 ps_bo_dof(output IN)  : COLOR
{
	float4 Original=tex2D(screen_sample,IN.uv);
	float3 Blurred = 0;
	for(int i = 0; i < NumSamples; i++)
	{
  	  float4 Current = tex2D(screen_sample, IN.uv + (TwelveKernelBase[i]/500.0));   
	  float origa = 1 - Original.a;
	  float curra = 1 - Current.a;
	  Blurred += lerp(Original.rgb, Current.rgb, saturate(origa*curra)*BlurFactor);
	}
 	float4 color=float4(Blurred / NumSamples, 1.0f);
	float4 bright=tex2D(bloom_sample,IN.uv);
	float4 result = color + bright;	
	return result;	
}

float4 ps_bo(output IN)  : COLOR
{
 	float4 color=tex2D(screen_sample,IN.uv);
 	float4 shade=tex2D(shadow_sample,IN.uv);
 	float4 bright=tex2D(bloom_sample,IN.uv);
	float4 result = color + bright;	
	return result;	
}


float4 ps_dof(output IN)  : COLOR
{
	float4 Original=tex2D(screen_sample,IN.uv);
	float3 Blurred = 0;
	for(int i = 0; i < NumSamples; i++)
	{
  	  float4 Current = tex2D(screen_sample, IN.uv + (TwelveKernelBase[i]/500.0));   
	  float origa = 1 - Original.a;
	  float curra = 1 - Current.a;
	  Blurred += lerp(Original.rgb, Current.rgb, saturate(origa*curra)*BlurFactor);
	}
 	float4 color=float4(Blurred / NumSamples, 1.0f);
	float4 result = color;	
	return result;	
}

float4 ps_off(output IN)  : COLOR
{
 	float4 color=tex2D(screen_sample,IN.uv);
 	float4 shade=tex2D(shadow_sample,IN.uv);
	float4 result = color;
	return result;	
}
  
technique shadowbloomanddepthoffield
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_b ps_all(); 	
	}
}

technique shadowandbloom
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_0 ps(); 	
	}
}

technique shadowdepthoffield
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_b ps_so_dof(); 	
	}
}

technique shadowonly
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_0 ps_so(); 	
	}
}

technique bloomdepthoffield
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_b ps_bo_dof(); 	
	}
}

technique bloomonly
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_0 ps_bo(); 	
	}
}

technique depthoffieldonly
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_b ps_dof(); 	
	}
}

technique off
{
	pass p1
	{
  		vertexShader = compile vs_1_1 vs(); 
		pixelShader  = compile ps_2_0 ps_off(); 	
	}
}
