//
// Metal
//

// Constants
matrix worldMatrix : World;	// World or Model matrix
matrix mvpMatrix : WorldViewProjection;	// Model*View*Projection
matrix worldViewMatrix : WorldView;
matrix viewInverseMatrix : ViewIT;
matrix worldInverse : WorldIT;
matrix viewMatrix : View;

// Model and Texture Names
string XFile = "default.x";
texture normalMap : NormalMap < string name = "bump.tga"; >;
texture cubeMap : EnvMap < string name = "dbprocubemap.dds"; string Type = "Cube"; >;

technique BumpReflect0
{
	pass p0
	{
		VertexShaderConstant[0] = <worldViewMatrix>; 		// c0-c3 is ModelView matrix
        	VertexShaderConstant[4] = <mvpMatrix>;			// c4-c7 is ModelViewProjection matrix
		VertexShaderConstant[8] = <viewInverseMatrix>;
		VertexShaderConstant[12] = { 0.25 ,-1.0,-1.0,1.0};	// 0.25 is the bump height
		VertexShaderConstant[13] = {1.0,0.0,0.0,1.0};

		VertexShader = 
		asm
	        {
        		vs.1.1					// version number

    			dcl_position   v0
    			dcl_normal     v3
    			dcl_color      v6
			dcl_texcoord   v7
			dcl_tangent    v8
			dcl_binormal   v9
			
			m4x4 oPos, v0, c4		// pos in screen space.
			
			dp3 r1.w, v8, v8		// normalize tangent
			rsq r1.w, r1.w
			mul r1, v8, r1.w		

			dp3 r2.w, v9, v9		// normalize binormal
			rsq r2.w, r2.w
			mul r2, v9, r2.w
			
			//mul r3, r1.zxyw, r2.yzxw	// cross product (i.e. normal)
			//mad r3, r1.yzxw, r2.zxyw, -r3
			mov r3, v3

			dp3 r3.w, r3, r3		// r3 = normal.
			rsq r3.w, r3.w
			mul r3, v3, r3.w

			mul r1, r1, c12.x
			mul r2, r2, c12.x

			dp3 oT1.x, r1, c0
			dp3 oT1.y, r2, c0
			dp3 oT1.z, r3, c0
			
			dp3 oT2.x, r1, c1
			dp3 oT2.y, r2, c1
			dp3 oT2.z, r3, c1
			
			dp3 oT3.x, r1, c2
			dp3 oT3.y, r2, c2
			dp3 oT3.z, r3, c2

			dp3 r5.x, r1, c2
			dp3 r5.y, r2, c2
			dp3 r5.z, r3, c2
			mov r5.w, c13.x

			m4x4 r4, v0, c0			// pos in world space
			sub r4, c11, r4			// r4 = eye vector in world space.
			
			mov oT1.w, r4.x
			mov oT2.w, r4.y
			mov oT3.w, r4.z
			
			mov oT0, v7	
			mov oD0, r5	
        	};
		
		Zenable = true;
		ZWriteEnable = true;
		CullMode = None;
		NormalizeNormals = true;
		
		Texture[0] = <normalMap>;
		MinFilter[0] = Linear;
		MagFilter[0] = Linear;
		MipFilter[0] = Linear;

		Texture[3] = <cubeMap>;
		MinFilter[3] = Linear;
		MagFilter[3] = Linear;
		MipFilter[3] = Linear;

		ColorOp[0] = Modulate;		// Here for now to force GL to use D3D defaults.
		ColorArg1[0] = Texture;
		ColorArg2[0] = Current;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = Current;

		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;

		PixelShader = 
		asm
		{
			ps.1.1
			tex t0
			texm3x3pad t1, t0_bx2
			texm3x3pad t2, t0_bx2		
			texm3x3vspec t3, t0_bx2
			mov r0, t3
		};
	}
}
